#include "../inc/QrfeProgressDialog.h"

#include <QTimer>

QrfeProgressDialog::QrfeProgressDialog(QrfeGlobal::ProgressBarMode mode, QWidget *parent)
    : QDialog(parent)
	, m_mode(mode)
    , m_stopable(false)
    , m_maximum(1)
    , m_stopped(false)
{
	ui.setupUi(this);

	prepare();
}

QrfeProgressDialog::QrfeProgressDialog(QString text, QrfeGlobal::ProgressBarMode mode, QWidget *parent)
    : QDialog(parent)
	, m_mode(mode)
    , m_stopable(false)
    , m_text(text)
    , m_maximum(1)
    , m_stopped(false)
{
	ui.setupUi(this);

	prepare();
}

QrfeProgressDialog::QrfeProgressDialog(QString text, uint steps, QWidget *parent)
    : QDialog(parent)
	, m_mode(QrfeGlobal::STATIC)
    , m_stopable(false)
    , m_text(text)
    , m_maximum(steps)
    , m_stopped(false)
{
	ui.setupUi(this);

	prepare();
}

QrfeProgressDialog::~QrfeProgressDialog()
{
    setVisible(false);
}


void QrfeProgressDialog::prepare()
{
	this->setModal ( true );
	this->setWindowTitle("Progress");

    ui.label->setText(m_text);
	ui.progressBar->setValue(0);
    ui.stopToolButton->setVisible(m_stopable);
    connect(ui.stopToolButton, SIGNAL(clicked(bool)), this, SLOT(stopButtonClicked()));

	switch(m_mode)
	{
	case QrfeGlobal::STATIC:
        ui.progressBar->setMaximum(m_maximum);
		ui.progressBar->setTextVisible(true);
		break;
	case QrfeGlobal::FLOATING:
		ui.progressBar->setTextVisible(false);
        ui.progressBar->setMaximum(100);
		break;
	}

	m_selfIncrement = false;
	m_timer = new QTimer(this);
    m_timer->setInterval(25);
	m_timer->setSingleShot(false);
	connect(m_timer, SIGNAL(timeout()), this, SLOT(doSelfIncrement()));
}

bool QrfeProgressDialog::stopped() const
{
    return m_stopped;
}

bool QrfeProgressDialog::stopable() const
{
    return m_stopable;
}

void QrfeProgressDialog::setStopable(bool stopable)
{
    m_stopable = stopable;
    ui.stopToolButton->setVisible(m_stopable);
    this->repaint();
}


QString QrfeProgressDialog::title()
{
    return this->windowTitle();
}

void QrfeProgressDialog::setTitle(QString title)
{
    this->setWindowTitle(title);
	this->repaint();
}


QString QrfeProgressDialog::text()
{
	return ui.label->text();
}

void QrfeProgressDialog::setText(QString text)
{
    m_text = text;
	ui.label->setText(text);
	this->repaint();
}


int QrfeProgressDialog::maxmimum()
{
	return ui.progressBar->maximum();
}

void QrfeProgressDialog::setMaximum(int maximum)
{
    m_maximum = maximum;
	ui.progressBar->setMaximum(maximum);
	this->repaint();
}


bool QrfeProgressDialog::selfIncrement()
{
	return m_selfIncrement;
}

void QrfeProgressDialog::setSelfIncrement(bool on)
{
	m_selfIncrement = on;
}


void QrfeProgressDialog::setVisible ( bool visible )
{
	if(visible){
		ui.progressBar->setValue(0);
		ui.progressBar->setInvertedAppearance(false);
		if(m_mode == QrfeGlobal::FLOATING && m_selfIncrement)
			m_timer->start();
	}
	else
		m_timer->stop();

	QDialog::setVisible(visible);
}


void QrfeProgressDialog::resetPorgressBar()
{
	ui.progressBar->setValue(0);
	this->repaint();
}

void QrfeProgressDialog::increasePorgressBar()
{
	switch(m_mode)
	{
	case QrfeGlobal::STATIC:
		if(ui.progressBar->value() < ui.progressBar->maximum()){
			ui.progressBar->setValue(ui.progressBar->value()+1);
			this->repaint();
		}
		break;
	case QrfeGlobal::FLOATING:
		if(ui.progressBar->invertedAppearance() == false)
		{
            ui.progressBar->setValue(ui.progressBar->value() + 2);
			if(ui.progressBar->value() == ui.progressBar->maximum())
				ui.progressBar->setInvertedAppearance(true);
		}
		else
		{
            ui.progressBar->setValue(ui.progressBar->value() - 2);
			if(ui.progressBar->value() == ui.progressBar->minimum())
				ui.progressBar->setInvertedAppearance(false);
		}
		this->repaint();
		break;
	}
}

void QrfeProgressDialog::progressChanged(int steps, int overall)
{
	ui.progressBar->setInvertedAppearance(false);
	ui.progressBar->setMaximum(overall);
	ui.progressBar->setValue(steps);
}


void QrfeProgressDialog::doSelfIncrement()
{
	if(!ui.progressBar->invertedAppearance()){
		if(ui.progressBar->value() < ui.progressBar->maximum())
            ui.progressBar->setValue(ui.progressBar->value()+2);
	}
	else {
		if(ui.progressBar->value() > 0)
            ui.progressBar->setValue(ui.progressBar->value()-2);
	}

	if(ui.progressBar->value() == ui.progressBar->maximum() || ui.progressBar->value() == 0)
	{
		ui.progressBar->setInvertedAppearance(!ui.progressBar->invertedAppearance());
    }
}

void QrfeProgressDialog::stopButtonClicked()
{
    m_stopped = true;
}
